' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.IO
Imports System.Security.Cryptography

Namespace Toolkit

  ''' <summary>
  ''' Klasa Imaging eksponuje metody do pracy z obrazami. Posiada metody do skalowania i kadrowania obrazw, dodawania tekstu do obrazw
  ''' i posiada medody pomocnikw dostarczajce listy rodzin czcionek oraz kolorw.
  ''' </summary>
  Public Class Imaging

#Region "Konstruktor(y)"
    ''' <summary>
    ''' Ukryj konstruktor aby unikn tworzenia instancji klasy Imaging.
    ''' </summary>
    Private Sub New()
    End Sub
#End Region

#Region "Metody pomocnicze"

    ''' <summary>
    ''' Zwraca tablic obiektw Color z wszystkimi znanymi kolorami.
    ''' </summary>
    ''' <param name="includeSystemColors">Ustala czy kolory systemowe, takie jak ActiveBorder maj by doczone do wyniku.</param>
    ''' <remarks>Kady obiekt Color w tablicy Colors() ma waciwo Name. Uzywaj tej waciwoci do wywietlania nazwy koloru przy wizaniu z kontrolkami. Na przykad ustaw DataTextField na "Name" tworzc powizanie z DropDownList.</remarks>
    Public Shared Function GetColors(ByVal includeSystemColors As Boolean) As Color()
      Dim tempColors As KnownColor() = _
          CType([Enum].GetValues(GetType(KnownColor)), KnownColor())

      Dim colors As New ArrayList

      For loopCount As Integer = 0 To tempColors.Length - 1
        If (Not Color.FromKnownColor(tempColors(loopCount)).IsSystemColor _
              Or includeSystemColors) And Not _
              Color.FromKnownColor(tempColors(loopCount)).Name = "Transparent" Then
          colors.Add(Color.FromKnownColor(tempColors(loopCount)))
        End If
      Next
      Return CType(colors.ToArray(GetType(Color)), Color())
    End Function

    ''' <summary>
    ''' Zwraca list dostpnych opcji <see cref="RotateFlipType" /> jako tablic ancuchw znakowych.
    ''' </summary>
    Public Shared Function GetRotateTypes() As String()
      Dim tempResult As String() = [Enum].GetNames(GetType(RotateFlipType))
      Array.Sort(tempResult)
      Return (tempResult)
    End Function

    ''' <summary>
    ''' Zwraca tablic obiektw FontFamiliy z wszystkimi znanymi rodzinami czcionek na  danym serwerze.
    ''' </summary>
    ''' <remarks>Kady obiekt FontFamily w tablicy FontFamily() posiada waciwo Name. Uzywaj tej waciwoci do wywietlania nazwy czcionki przy wizaniu z kontrolkami. Na przykad ustaw DataTextField na "Name" tworzc powizanie z DropDownList.</remarks>
    Public Shared Function GetFontFamilies() As FontFamily()
      Dim fonts As New ArrayList

      For loopCount As Integer = 0 To FontFamily.Families.Length - 1
        fonts.Add(FontFamily.Families(loopCount))
      Next
      Return CType(fonts.ToArray(GetType(FontFamily)), FontFamily())
    End Function

#End Region

#Region "Metody do napisw na obrazie"

    ''' <summary>
    ''' Dodaje w wybranym miejscu obrazu napis o okrelonym kolorze i czcionce.
    ''' </summary>
    ''' <param name="fileNameIn">Pena cieka fizyczna do obrazka rdowego i wynikowego.</param>
    ''' <param name="myFont">Czcionka zastosowana w napisie.</param>
    ''' <param name="fontColor">Kolor czcionki.</param>
    ''' <param name="textLocation">Wsprzdne X i Y pooenia tekstu.</param>
    ''' <param name="textToAdd">Tekst, ktry ma zosta dodany do obrazu.</param>
    ''' <remarks>Ta metoda zawisze zapisuje obraz jako plik JPG.
    ''' Ta metoda nadpisuje oryginalny obraz.</remarks>
    Public Shared Sub AddTextToImage(ByVal fileNameIn As String, ByVal myFont As Font, ByVal fontColor As Color, ByVal textLocation As Point, ByVal textToAdd As String)
      AddTextToImage(fileNameIn, fileNameIn, myFont, fontColor, textLocation, textToAdd)
    End Sub

    ''' <summary>
    ''' Dodaje w wybranym miejscu obrazu napis o okrelonym kolorze i czcionce.
    ''' </summary>
    ''' <param name="fileNameIn">Pena cieka fizyczna do obrazka rdowego.</param>
    ''' <param name="fileNameOut">Pena cieka fizyczna do obrazka wynikowego.</param>
    ''' <param name="myFont">Czcionka zastosowana w napisie.</param>
    ''' <param name="fontColor">Kolor czcionki.</param>
    ''' <param name="textLocation">Wsprzdne X i Y pooenia tekstu.</param>
    ''' <param name="textToAdd">Tekst, ktry ma zosta dodany do obrazu.</param>
    ''' <remarks>Ta metoda zawisze zapisuje obraz jako plik JPG.</remarks>
    Public Shared Sub AddTextToImage(ByVal fileNameIn As String, ByVal fileNameOut As String, ByVal myFont As Font, ByVal fontColor As Color, ByVal textLocation As Point, ByVal textToAdd As String)

      Dim myGraphics As Graphics = Nothing
      Dim myBitmap As Bitmap = Nothing

      Try
        myBitmap = New Bitmap(fileNameIn)

        ' Utwrz nowy obiekt Graphics, ktry posuy jako nasze "ptno do rysowania"
        myGraphics = Graphics.FromImage(myBitmap)

        ' Okrel wyrwnanie tekstu
        Dim myStringFormat As StringFormat = New StringFormat
        myStringFormat.Alignment = StringAlignment.Near

        ' Okrel antyaliasing dla napisw, ktre dodamy do obrazu
        myGraphics.TextRenderingHint = Drawing.Text.TextRenderingHint.AntiAlias

        Dim myBrush As SolidBrush = New SolidBrush(fontColor)

        myGraphics.DrawString(textToAdd, myFont, myBrush, New Point(textLocation.X, textLocation.Y), myStringFormat)
        myBitmap.Save(fileNameOut, ImageFormat.Jpeg)
      Catch ex As Exception
        Throw
      Finally
        If myGraphics IsNot Nothing Then
          myGraphics.Dispose()
        End If
        If myBitmap IsNot Nothing Then
          myBitmap.Dispose()
        End If
      End Try
    End Sub

#End Region

#Region "Metody kadrowania"

    ''' <summary>
    ''' Obcina obraz do kadru okrelonego przez theRectangle.
    ''' </summary>
    ''' <param name="fileNameIn">Nazwa pliku obrazu do kadrowania.</param>
    ''' <param name="theRectangle">Okrela pooenie i rozmiar kadru.</param>
    ''' <remarks>Ta przeadowana wersja zawsze nadpisuje oryginalny obraz.</remarks>
    Public Shared Sub CropImage(ByVal fileNameIn As String, ByVal theRectangle As Rectangle)
      CropImage(fileNameIn, fileNameIn, theRectangle)
    End Sub

    ''' <summary>
    ''' Obcina obraz do kadru okrelonego przez theRectangle.
    ''' </summary>
    ''' <param name="fileNameIn">Nazwa pliku obrazu do kadrowania.</param>
    ''' <param name="fileNameOut">Nazwa pliku obrazu wynikowego.</param>
    ''' <param name="theRectangle">Okrela pooenie i rozmiar kadru.</param>
    Public Shared Sub CropImage(ByVal fileNameIn As String, _
            ByVal fileNameOut As String, ByVal theRectangle As Rectangle)
      Dim myBitmap As Bitmap = Nothing
      Dim myBitmapCropped As Bitmap = Nothing
      Dim myGraphics As Graphics = Nothing

      Try
        ' Otwrz oryginalny obraz
        myBitmap = New Bitmap(fileNameIn)

        ' Stwrz drug bitmap, ktra posuy jako ptno na ktrym zostanie umieszczony wykadrowany obraz
        myBitmapCropped = New Bitmap(theRectangle.Width, theRectangle.Height)
        myGraphics = Graphics.FromImage(myBitmapCropped)

        myGraphics.DrawImage(myBitmap, New Rectangle(0, 0, myBitmapCropped.Width, _
              myBitmapCropped.Height), theRectangle.Left, theRectangle.Top, _
              theRectangle.Width, theRectangle.Height, GraphicsUnit.Pixel)

        myBitmap.Dispose()
        myBitmapCropped.Save(fileNameOut, ImageFormat.Jpeg)

      Catch ex As Exception
        Throw
      Finally
        If myBitmap IsNot Nothing Then
          myBitmap.Dispose()
        End If
        If myBitmapCropped IsNot Nothing Then
          myBitmapCropped.Dispose()
        End If
        If myGraphics IsNot Nothing Then
          myGraphics.Dispose()
        End If
      End Try
    End Sub


    ''' <summary>
    ''' Rysuje prostokt na istniejcym obrazie.
    ''' </summary>
    ''' <param name="fileNameIn">Pena cieka fizyczna do obrazka rdowego i wynikowego.</param>
    ''' <param name="theRectangle">Okrela pooenie i krawdzie obiektu Rectangle ktry ma by rysowany.</param>
    ''' <param name="myColor">Kolor linii prostokta.</param>
    ''' <remarks>Ta metoda nadpisuje oryginalny obraz.</remarks>
    Public Shared Sub DrawRectangle(ByVal fileNameIn As String, ByVal theRectangle As Rectangle, ByVal myColor As Color)
      DrawRectangle(fileNameIn, fileNameIn, theRectangle, myColor)
    End Sub

    ''' <summary>
    ''' Rysuje prostokt na istniejcym obrazie.
    ''' </summary>
    ''' <param name="fileNameIn">Pena cieka fizyczna do obrazka rdowego.</param>
    ''' <param name="fileNameOut">Pena cieka fizyczna do obrazka wynikowego.</param>
    ''' <param name="theRectangle">Okrela pooenie i krawdzie obiektu Rectangle ktry ma by rysowany.</param>
    ''' <param name="myColor">Kolor linii prostokta.</param>
    Public Shared Sub DrawRectangle(ByVal fileNameIn As String, _
          ByVal fileNameOut As String, ByVal theRectangle As Rectangle, _
          ByVal myColor As Color)

      Dim myGraphics As Graphics = Nothing
      Dim myBitmap As Bitmap = Nothing

      Try
        myBitmap = New Bitmap(fileNameIn)
        myGraphics = Graphics.FromImage(myBitmap)

        Dim myPen As New Pen(myColor, 1)
        myGraphics.SmoothingMode = Drawing2D.SmoothingMode.None
        myGraphics.DrawRectangle(myPen, theRectangle)
        myPen.Dispose()

        myBitmap.Save(fileNameOut, ImageFormat.Jpeg)
      Catch ex As Exception
        Throw
      Finally
        If myBitmap IsNot Nothing Then
          myBitmap.Dispose()
        End If
        If myGraphics IsNot Nothing Then
          myGraphics.Dispose()
        End If
      End Try
    End Sub


#End Region

#Region "Metody obracania"

    ''' <summary>
    ''' Obraca obraz zgodnie z wartoci theRotateFlipType.
    ''' </summary>
    ''' <param name="fileNameIn">ciezka do obrazka, ktry ma by obrcony.</param>
    ''' <param name="fileNameOut">Miejsce, gdzie ma by zapisany obrcony obraz </param>
    ''' <param name="theRotateFlipType">Typ obrotu.</param>
    Public Shared Sub RotateImage(ByVal fileNameIn As String, ByVal fileNameOut As String, ByVal theRotateFlipType As RotateFlipType)
      Using myBitmap As New Bitmap(fileNameIn)
        myBitmap.RotateFlip(theRotateFlipType)
        myBitmap.Save(fileNameOut, ImageFormat.Jpeg)
      End Using
    End Sub

    ''' <summary>
    ''' Obraca obraz zgodnie z wartoci theRotateFlipType.
    ''' </summary>
    ''' <param name="fileNameIn">ciezka do obrazka, ktry ma by obrcony.</param>
    ''' <param name="theRotateFlipType">Typ obrotu.</param>
    ''' <remarks>Ta metoda nadpisuje oryginalny obraz.</remarks>
    Public Shared Sub RotateImage(ByVal fileNameIn As String, ByVal theRotateFlipType As RotateFlipType)
      RotateImage(fileNameIn, fileNameIn, theRotateFlipType)
    End Sub

#End Region

#Region "Metody skalowania"

    ''' <summary>
    ''' Skaluje obraz do danej maksymalnej wysokoci lub szerokoci. Zawsze zwraca obraz JPEG. Uyj jednej z innych metod przecionych, jeli chcesz okreli inny typ obrazu.
    ''' </summary>
   ''' <param name="fileNameIn">Nazwa pliku rdowego. Ta nazwa jest te uywana jako plik docelowy, wic rdo zostaje nadpisane.
    ''' Jeli nie chcesz nadpisywa pliku, uyj jednej z metod przecionych, ktre przyjmuj parametry fileNameIn i fileNameOut.</param>
    ''' <param name="maxHeight">Maksymalna wysoko obrazu w pikselach.</param>
    ''' <param name="maxWidth">Maksymalna szeroko obrazu w pikselach.</param>
    Public Shared Sub ResizeImage(ByVal fileNameIn As String, ByVal maxWidth As Integer, ByVal maxHeight As Integer)
      ResizeImage(fileNameIn, fileNameIn, maxWidth, maxHeight, ImageFormat.Jpeg)
    End Sub

    ''' <summary>
    ''' Skaluje obraz do danej maksymalnej wysokoci lub szerokoci. Zawsze zwraca obraz JPEG. Uyj jednej z innych metod przecionych, jeli chcesz okreli inny typ obrazu.
    ''' </summary>
    ''' <param name="fileNameIn">Nazwa pliku rdowego. Ta nazwa jest te uywana jako plik docelowy, wic rdo zostaje nadpisane.
    ''' Jeli nie chcesz nadpisywa pliku, uyj jednej z metod przecionych, ktre przyjmuj parametry fileNameIn i fileNameOut.</param>
    ''' <param name="maxWidthOrWidth">Maksymalna wysoko obrazu w pikselach.</param>
    Public Shared Sub ResizeImage(ByVal fileNameIn As String, ByVal maxWidthOrWidth As Integer)
      ResizeImage(fileNameIn, fileNameIn, maxWidthOrWidth, ImageFormat.Jpeg)
    End Sub

    ''' <summary>
    ''' Skaluje obraz do danych wymiarw okrelonych przez argument Size. Zawsze zwraca obraz JPEG. 
    ''' </summary>
    ''' <param name="fileNameIn">Nazwa pliku rdowego.</param>
    ''' <param name="fileNameOut">Nazwa pliku docelowego.</param>
    ''' <param name="theSize">Przechowuje nowe wymiary obrazu.</param>
    Public Shared Sub ResizeImage(ByVal fileNameIn As String, ByVal fileNameOut As String, ByVal theSize As Size)
      ResizeImage(fileNameIn, fileNameOut, theSize, ImageFormat.Jpeg)
    End Sub


    ''' <summary>
    ''' Skaluje obraz do danej maksymalnej wysokoci lub szerokoci.
    ''' </summary>
    ''' <param name="fileNameIn">Nazwa pliku rdowego.</param>
    ''' <param name="fileNameOut">Nazwa pliku docelowego.</param>
    ''' <param name="maxWidthOrHeight">Maksymalna wysoko lub szeroko obrazu docelowego.</param>
    ''' <param name="theImageFormat">Format, w jakim obraz docelowy ma by zapisany.</param>
    Public Shared Sub ResizeImage(ByVal fileNameIn As String, ByVal fileNameOut As String, ByVal maxWidthOrHeight As Integer, ByVal theImageFormat As ImageFormat)
      Dim portrait As Boolean = False
      Dim bmpSource As Bitmap = Nothing

      ' Otwrz obrazek
      bmpSource = New Bitmap(fileNameIn)

      Dim originalSize As Size = bmpSource.Size
      Dim newSize As Size = New Size(0, 0)

      bmpSource.Dispose()

      Dim maxHeightDecimal As Decimal = Convert.ToDecimal(maxWidthOrHeight)
      Dim maxWidthAsDecimal As Decimal = Convert.ToDecimal(maxWidthOrHeight)

      Dim resizeFactor As Decimal

      If (originalSize.Height > originalSize.Width) Then
        ' Orientacja pionowa
        resizeFactor = Convert.ToDecimal(Decimal.Divide(originalSize.Height, maxHeightDecimal))
        newSize.Height = maxWidthOrHeight
        newSize.Width = Convert.ToInt32(originalSize.Width / resizeFactor)
      Else
        ' Orientacja pozioma lub kwadrat
        resizeFactor = Convert.ToDecimal(Decimal.Divide(originalSize.Width, maxWidthAsDecimal))
        newSize.Width = maxWidthOrHeight
        newSize.Height = Convert.ToInt32(originalSize.Height / resizeFactor)
      End If

      'Gdy ju obliczylimy wymiary, przekazujemy wywoanie do metody ResizeImage, ktra dokonuje rzeczywistego skalowania.
      ResizeImage(fileNameIn, fileNameOut, newSize, theImageFormat)
    End Sub


    ''' <summary>
    ''' Skaluje obraz do danej maksymalnej wysokoci lub szerokoci.
    ''' </summary>
    ''' <param name="fileNameIn">Nazwa pliku rdowego.</param>
    ''' <param name="fileNameOut">Nazwa pliku docelowego.</param>
    ''' <param name="maxWidth">Maksymalna szeroko, jak moe mie obraz docelowy.</param>
    ''' <param name="maxHeight">Maksymalna wysoko, jak moe mie obraz docelowy.</param>
    ''' <param name="theImageFormat">Format, w jakim obraz docelowy ma by zapisany.</param>
    Public Shared Sub ResizeImage(ByVal fileNameIn As String, ByVal fileNameOut As String, ByVal maxWidth As Integer, ByVal maxHeight As Integer, ByVal theImageFormat As ImageFormat)
      Dim originalSize As Size = GetImageSize(fileNameIn)
      Dim newSize As Size = New Size(0, 0)

      Dim resizeFactor As Decimal = System.Math.Max( _
          Convert.ToDecimal(Decimal.Divide(originalSize.Height, maxHeight)), _
          Convert.ToDecimal(Decimal.Divide(originalSize.Width, maxWidth)))

      newSize.Height = Convert.ToInt32(originalSize.Height / resizeFactor)
      newSize.Width = Convert.ToInt32(originalSize.Width / resizeFactor)

      'Gdy ju obliczylimy wymiary, przekazujemy wywoanie do metody ResizeImage, ktra dokonuje rzeczywistego skalowania.
      ResizeImage(fileNameIn, fileNameOut, newSize, theImageFormat)
    End Sub

    ''' <summary>
    ''' Skaluje obraz do wymiarw wskazanych przez argument theSize.
    ''' </summary>
    ''' <param name="fileNameIn">Nazwa pliku rdowego.</param>
    ''' <param name="fileNameOut">Nazwa pliku docelowego.</param>
    ''' <param name="theSize">Nowe rozmiary pliku docelowego.</param>
    ''' <param name="theImageFormat">Format, w jakim obraz docelowy ma by zapisany.</param>
    Public Shared Sub ResizeImage(ByVal fileNameIn As String, ByVal fileNameOut As String, ByVal theSize As Size, ByVal theImageFormat As ImageFormat)
      Dim mySourceBitmap As Bitmap = Nothing
      Dim myTargetBitmap As Bitmap = Nothing
      Dim myGraphics As Graphics = Nothing

      Try
        mySourceBitmap = New Bitmap(fileNameIn)

        Dim newWidth As Integer = theSize.Width
        Dim newHeight As Integer = theSize.Height

        myTargetBitmap = New Bitmap(newWidth, newHeight)

        myGraphics = Graphics.FromImage(myTargetBitmap)

        myGraphics.InterpolationMode = _
                  System.Drawing.Drawing2D.InterpolationMode.HighQualityBicubic

        myGraphics.DrawImage(mySourceBitmap, New Rectangle(0, 0, newWidth, newHeight))
        mySourceBitmap.Dispose()

        ' Zapisz nowy obraz
        myTargetBitmap.Save(fileNameOut, theImageFormat)
      Catch
        Throw
      Finally
        If (myGraphics IsNot Nothing) Then
          myGraphics.Dispose()
        End If
        If mySourceBitmap IsNot Nothing Then
          mySourceBitmap.Dispose()
        End If
        If myTargetBitmap IsNot Nothing Then
          myTargetBitmap.Dispose()
        End If
      End Try
    End Sub


#End Region

#Region "Inne metody obrazowania"

    ''' <summary>
    ''' Zwraca rozmiary obrazu.
    ''' </summary>
    ''' <param name="fileNameIn">cieka dla obrazka, dla ktrego ma by zwrcony obiekt Size.</param>
    Public Shared Function GetImageSize(ByVal fileNameIn As String) As Size

      Dim myBitmap As Bitmap = Nothing
      Dim theSize As Size = Size.Empty

      Try
        ' Otwrz obraz
        myBitmap = New Bitmap(fileNameIn)
        theSize = myBitmap.Size
      Catch
        ' Ignoruj; zwracamy obiekt Size. W tym wypadku pusty
      Finally
        If myBitmap IsNot Nothing Then
          myBitmap.Dispose()
        End If
      End Try
      Return theSize
    End Function

    ''' <summary>
    ''' Zwraca obiekt ImageFormat dla danego obrazu.
    ''' </summary>
    ''' <param name="fileNameIn">ciezka do obrazka, dla ktrego ma by zwrcony ImageFormat.</param>
    Public Shared Function GetImageFormat(ByVal fileNameIn As String) As ImageFormat

      Dim bmpSource As Bitmap = Nothing
      Dim theFormat As ImageFormat = Nothing

      Try
        ' Open the image
        bmpSource = New Bitmap(fileNameIn)
        theFormat = bmpSource.RawFormat
      Catch
        Throw
      Finally
        bmpSource.Dispose()
      End Try
      Return theFormat
    End Function

    ''' <summary>
    ''' Zwraca unikaln warto skrtu ("odcisk palca") obrazu.
    ''' </summary>
    ''' <param name="fileNameIn">cieka do obrazka, dla ktrego ma by zwrcona warto ImageHash.</param>
    Public Shared Function GetImageHash(ByVal fileNameIn As String) As String
      Dim myBitmap As Bitmap = Nothing
      Try
        myBitmap = New Bitmap(fileNameIn)
        Dim stream As MemoryStream = New MemoryStream()
        myBitmap.Save(stream, ImageFormat.Bmp)
        Dim bytes() As Byte = stream.ToArray()
        Dim HashVal() As Byte = (New MD5CryptoServiceProvider()).ComputeHash(bytes)

        Return Convert.ToBase64String(HashVal)
      Catch oomEx As OutOfMemoryException
        Throw New ArgumentException("cieka dostpu nie zawiera poprawnego obrazka")
      Catch aEx As ArgumentException
        Throw New ArgumentException("cieka nie jest waciwa")
      Catch fnfEx As FileNotFoundException
        Throw New ArgumentException("NIe znaleziono pliku")
      Catch ex As Exception
        Throw
      Finally
        If myBitmap IsNot Nothing Then
          myBitmap.Dispose()
        End If
      End Try
    End Function
#End Region

  End Class
End Namespace